/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GobEntity;
import superlord.goblinsanddungeons.entity.HobGobEntity;

@OnlyIn(value=Dist.CLIENT)
public class HobgobModel<T extends Entity>
extends EntityModel<HobGobEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("modid", "custom_model"), "main");
    private final ModelPart LeftLeg;
    private final ModelPart RightArm;
    private final ModelPart Head;
    private final ModelPart RightLeg;
    private final ModelPart LeftArm;
    private final ModelPart Body;

    public HobgobModel(ModelPart root) {
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.RightArm = root.m_171324_("RightArm");
        this.Head = root.m_171324_("Head");
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftArm = root.m_171324_("LeftArm");
        this.Body = root.m_171324_("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-2.0f, 0.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171480_().m_171488_(0.0f, -2.0f, -2.0f, 3.0f, 21.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -7.0f, 8.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-3.0f));
        PartDefinition Leftear = Head.m_171599_("Leftear", CubeListBuilder.m_171558_().m_171514_(36, 27).m_171480_().m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-4.0f, (float)-3.0f));
        PartDefinition Beard = Head.m_171599_("Beard", CubeListBuilder.m_171558_().m_171514_(14, 46).m_171488_(-5.0f, -2.0f, -3.0f, 10.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition Hair = Head.m_171599_("Hair", CubeListBuilder.m_171558_().m_171514_(36, 1).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)3.0f));
        PartDefinition nose = Head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-2.0f, -1.0f, -4.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-7.0f));
        PartDefinition Rightear = Head.m_171599_("Rightear", CubeListBuilder.m_171558_().m_171514_(36, 27).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-4.0f, (float)-3.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171480_().m_171488_(-1.0f, 0.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-3.0f, -2.0f, -2.0f, 3.0f, 21.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(HobGobEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightArm.f_104203_ = 0.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        List gob1 = entity.f_19853_.m_45976_(GobEntity.class, entity.m_142469_().m_82377_(1.0, 1.0, 1.0));
        List player = entity.f_19853_.m_45976_(Player.class, entity.m_142469_().m_82377_(8.0, 8.0, 8.0));
        if (!gob1.isEmpty() && !player.isEmpty() && entity.m_5448_() == null) {
            this.RightArm.f_104203_ = -Mth.m_14154_((float)(-1.0f * Mth.m_14031_((float)(1.0f * ageInTicks / 10.0f))));
            this.LeftArm.f_104203_ = -Mth.m_14154_((float)(-1.0f * Mth.m_14031_((float)(1.0f * ageInTicks / 10.0f))));
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.LeftLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.RightArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.RightLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.LeftArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

